package djnativead

import (
	"djgetad"
	"djgetad_models"
	"djlogger"
	openrtb3 "openrtb/openrtb3"

	openrtb "openrtb/openrtb2.5"
)

/*"Function to get native ad"*/
func GetNativeads(nativeChannel chan []djgetad.GetAd, nativefmt map[string]interface{}, req_details map[string]interface{}, pmp int8, deals []openrtb3.Deal) {
	storagetype := "bannerTypeHtml:oxHtml:native"
	nativeads, err := djgetad_models.NativeSearch(nativefmt, req_details["dsp_id"].(int), storagetype, pmp, deals, nil)
	if err != nil {
		djlogger.Log.Println(err)
	}
	nativeChannel <- nativeads
}

// Function to get native ad 2.5
func GetNativeads25(nativeChannel chan []djgetad.GetAd, nativefmt map[string]interface{}, req_details map[string]interface{}, pmp int8, deals []openrtb.Deal) {
	storagetype := "bannerTypeHtml:oxHtml:native"
	nativeads, err := djgetad_models.NativeSearch(nativefmt, req_details["dsp_id"].(int), storagetype, pmp, nil, deals)
	if err != nil {
		djlogger.Log.Println(err)
	}
	nativeChannel <- nativeads
}
